#!/bin/bash


envs=(
    "halfcheetah-medium-v2"
    "halfcheetah-medium-replay-v2"
    "halfcheetah-medium-expert-v2"
    "hopper-medium-v2"
    "hopper-medium-replay-v2"
    "hopper-medium-expert-v2"
    "walker2d-medium-v2"
    "walker2d-medium-replay-v2"
    "walker2d-medium-expert-v2"

    "antmaze-large-diverse-v0"
    "antmaze-large-play-v0"
    "antmaze-medium-diverse-v0"
    "antmaze-medium-play-v0"
    "antmaze-umaze-diverse-v0"
    "antmaze-umaze-v0"

    "door-cloned-v0"
    "door-human-v0"
    "hammer-cloned-v0"
    "hammer-human-v0"
    "pen-cloned-v0"
    "pen-human-v0"
    "relocate-cloned-v0"
    "relocate-human-v0"
)

declare -A pids

temp_log_dir="./reward_logs/llm_temp_logs"
if [ ! -d "$temp_log_dir" ]; then
    mkdir -p "$temp_log_dir"
    echo "$temp_log_dir created"
else
    echo "$temp_log_dir already exists"
fi

for env in "${envs[@]}"; do
    python reward_design/code_generation.py --env_name "$env" > "${temp_log_dir}/${env}.log" 2>&1 &
    pids[$!]=$env
done

all_success=true

for pid in "${!pids[@]}"; do
    wait "$pid"
    status=$?
    if [ $status -eq 0 ]; then
        echo "Command for env '${pids[$pid]}' completed successfully."
    else
        echo "Command for env '${pids[$pid]}' failed with status $status."
        all_success=false
    fi
done

if $all_success; then
    echo "======All processes completed successfully======"
else
    echo "======Some processes failed. Please check the logs======"
fi
